<?php

namespace NF_FU_VENDOR;

// This file was auto-generated from sdk-root/src/data/securityhub/2018-10-26/api-2.json
return ['version' => '2.0', 'metadata' => ['apiVersion' => '2018-10-26', 'endpointPrefix' => 'securityhub', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceFullName' => 'AWS SecurityHub', 'serviceId' => 'SecurityHub', 'signatureVersion' => 'v4', 'signingName' => 'securityhub', 'uid' => 'securityhub-2018-10-26'], 'operations' => ['AcceptInvitation' => ['name' => 'AcceptInvitation', 'http' => ['method' => 'POST', 'requestUri' => '/master'], 'input' => ['shape' => 'AcceptInvitationRequest'], 'output' => ['shape' => 'AcceptInvitationResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'LimitExceededException'], ['shape' => 'ResourceNotFoundException'], ['shape' => 'InvalidAccessException']]], 'BatchDisableStandards' => ['name' => 'BatchDisableStandards', 'http' => ['method' => 'POST', 'requestUri' => '/standards/deregister'], 'input' => ['shape' => 'BatchDisableStandardsRequest'], 'output' => ['shape' => 'BatchDisableStandardsResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException']]], 'BatchEnableStandards' => ['name' => 'BatchEnableStandards', 'http' => ['method' => 'POST', 'requestUri' => '/standards/register'], 'input' => ['shape' => 'BatchEnableStandardsRequest'], 'output' => ['shape' => 'BatchEnableStandardsResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException']]], 'BatchImportFindings' => ['name' => 'BatchImportFindings', 'http' => ['method' => 'POST', 'requestUri' => '/findings/import'], 'input' => ['shape' => 'BatchImportFindingsRequest'], 'output' => ['shape' => 'BatchImportFindingsResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'LimitExceededException'], ['shape' => 'InvalidAccessException']]], 'CreateActionTarget' => ['name' => 'CreateActionTarget', 'http' => ['method' => 'POST', 'requestUri' => '/actionTargets'], 'input' => ['shape' => 'CreateActionTargetRequest'], 'output' => ['shape' => 'CreateActionTargetResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException'], ['shape' => 'ResourceConflictException']]], 'CreateInsight' => ['name' => 'CreateInsight', 'http' => ['method' => 'POST', 'requestUri' => '/insights'], 'input' => ['shape' => 'CreateInsightRequest'], 'output' => ['shape' => 'CreateInsightResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'LimitExceededException'], ['shape' => 'InvalidAccessException'], ['shape' => 'ResourceConflictException']]], 'CreateMembers' => ['name' => 'CreateMembers', 'http' => ['method' => 'POST', 'requestUri' => '/members'], 'input' => ['shape' => 'CreateMembersRequest'], 'output' => ['shape' => 'CreateMembersResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'LimitExceededException'], ['shape' => 'InvalidAccessException'], ['shape' => 'ResourceConflictException']]], 'DeclineInvitations' => ['name' => 'DeclineInvitations', 'http' => ['method' => 'POST', 'requestUri' => '/invitations/decline'], 'input' => ['shape' => 'DeclineInvitationsRequest'], 'output' => ['shape' => 'DeclineInvitationsResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'ResourceNotFoundException']]], 'DeleteActionTarget' => ['name' => 'DeleteActionTarget', 'http' => ['method' => 'DELETE', 'requestUri' => '/actionTargets/{ActionTargetArn+}'], 'input' => ['shape' => 'DeleteActionTargetRequest'], 'output' => ['shape' => 'DeleteActionTargetResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'ResourceNotFoundException']]], 'DeleteInsight' => ['name' => 'DeleteInsight', 'http' => ['method' => 'DELETE', 'requestUri' => '/insights/{InsightArn+}'], 'input' => ['shape' => 'DeleteInsightRequest'], 'output' => ['shape' => 'DeleteInsightResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException'], ['shape' => 'ResourceNotFoundException']]], 'DeleteInvitations' => ['name' => 'DeleteInvitations', 'http' => ['method' => 'POST', 'requestUri' => '/invitations/delete'], 'input' => ['shape' => 'DeleteInvitationsRequest'], 'output' => ['shape' => 'DeleteInvitationsResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'LimitExceededException'], ['shape' => 'ResourceNotFoundException'], ['shape' => 'InvalidAccessException']]], 'DeleteMembers' => ['name' => 'DeleteMembers', 'http' => ['method' => 'POST', 'requestUri' => '/members/delete'], 'input' => ['shape' => 'DeleteMembersRequest'], 'output' => ['shape' => 'DeleteMembersResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException'], ['shape' => 'ResourceNotFoundException']]], 'DescribeActionTargets' => ['name' => 'DescribeActionTargets', 'http' => ['method' => 'POST', 'requestUri' => '/actionTargets/get'], 'input' => ['shape' => 'DescribeActionTargetsRequest'], 'output' => ['shape' => 'DescribeActionTargetsResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'ResourceNotFoundException']]], 'DescribeHub' => ['name' => 'DescribeHub', 'http' => ['method' => 'GET', 'requestUri' => '/accounts'], 'input' => ['shape' => 'DescribeHubRequest'], 'output' => ['shape' => 'DescribeHubResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'LimitExceededException'], ['shape' => 'InvalidAccessException'], ['shape' => 'InvalidInputException'], ['shape' => 'ResourceNotFoundException']]], 'DescribeProducts' => ['name' => 'DescribeProducts', 'http' => ['method' => 'GET', 'requestUri' => '/products'], 'input' => ['shape' => 'DescribeProductsRequest'], 'output' => ['shape' => 'DescribeProductsResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'LimitExceededException'], ['shape' => 'InvalidAccessException'], ['shape' => 'InvalidInputException']]], 'DisableImportFindingsForProduct' => ['name' => 'DisableImportFindingsForProduct', 'http' => ['method' => 'DELETE', 'requestUri' => '/productSubscriptions/{ProductSubscriptionArn+}'], 'input' => ['shape' => 'DisableImportFindingsForProductRequest'], 'output' => ['shape' => 'DisableImportFindingsForProductResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'ResourceNotFoundException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException']]], 'DisableSecurityHub' => ['name' => 'DisableSecurityHub', 'http' => ['method' => 'DELETE', 'requestUri' => '/accounts'], 'input' => ['shape' => 'DisableSecurityHubRequest'], 'output' => ['shape' => 'DisableSecurityHubResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'LimitExceededException'], ['shape' => 'InvalidAccessException'], ['shape' => 'ResourceNotFoundException']]], 'DisassociateFromMasterAccount' => ['name' => 'DisassociateFromMasterAccount', 'http' => ['method' => 'POST', 'requestUri' => '/master/disassociate'], 'input' => ['shape' => 'DisassociateFromMasterAccountRequest'], 'output' => ['shape' => 'DisassociateFromMasterAccountResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException'], ['shape' => 'ResourceNotFoundException']]], 'DisassociateMembers' => ['name' => 'DisassociateMembers', 'http' => ['method' => 'POST', 'requestUri' => '/members/disassociate'], 'input' => ['shape' => 'DisassociateMembersRequest'], 'output' => ['shape' => 'DisassociateMembersResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException'], ['shape' => 'ResourceNotFoundException']]], 'EnableImportFindingsForProduct' => ['name' => 'EnableImportFindingsForProduct', 'http' => ['method' => 'POST', 'requestUri' => '/productSubscriptions'], 'input' => ['shape' => 'EnableImportFindingsForProductRequest'], 'output' => ['shape' => 'EnableImportFindingsForProductResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'ResourceConflictException'], ['shape' => 'LimitExceededException']]], 'EnableSecurityHub' => ['name' => 'EnableSecurityHub', 'http' => ['method' => 'POST', 'requestUri' => '/accounts'], 'input' => ['shape' => 'EnableSecurityHubRequest'], 'output' => ['shape' => 'EnableSecurityHubResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'LimitExceededException'], ['shape' => 'InvalidAccessException'], ['shape' => 'ResourceConflictException'], ['shape' => 'AccessDeniedException']]], 'GetEnabledStandards' => ['name' => 'GetEnabledStandards', 'http' => ['method' => 'POST', 'requestUri' => '/standards/get'], 'input' => ['shape' => 'GetEnabledStandardsRequest'], 'output' => ['shape' => 'GetEnabledStandardsResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException']]], 'GetFindings' => ['name' => 'GetFindings', 'http' => ['method' => 'POST', 'requestUri' => '/findings'], 'input' => ['shape' => 'GetFindingsRequest'], 'output' => ['shape' => 'GetFindingsResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException']]], 'GetInsightResults' => ['name' => 'GetInsightResults', 'http' => ['method' => 'GET', 'requestUri' => '/insights/results/{InsightArn+}'], 'input' => ['shape' => 'GetInsightResultsRequest'], 'output' => ['shape' => 'GetInsightResultsResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException'], ['shape' => 'ResourceNotFoundException']]], 'GetInsights' => ['name' => 'GetInsights', 'http' => ['method' => 'POST', 'requestUri' => '/insights/get'], 'input' => ['shape' => 'GetInsightsRequest'], 'output' => ['shape' => 'GetInsightsResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException'], ['shape' => 'ResourceNotFoundException']]], 'GetInvitationsCount' => ['name' => 'GetInvitationsCount', 'http' => ['method' => 'GET', 'requestUri' => '/invitations/count'], 'input' => ['shape' => 'GetInvitationsCountRequest'], 'output' => ['shape' => 'GetInvitationsCountResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException']]], 'GetMasterAccount' => ['name' => 'GetMasterAccount', 'http' => ['method' => 'GET', 'requestUri' => '/master'], 'input' => ['shape' => 'GetMasterAccountRequest'], 'output' => ['shape' => 'GetMasterAccountResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException'], ['shape' => 'ResourceNotFoundException']]], 'GetMembers' => ['name' => 'GetMembers', 'http' => ['method' => 'POST', 'requestUri' => '/members/get'], 'input' => ['shape' => 'GetMembersRequest'], 'output' => ['shape' => 'GetMembersResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException'], ['shape' => 'ResourceNotFoundException']]], 'InviteMembers' => ['name' => 'InviteMembers', 'http' => ['method' => 'POST', 'requestUri' => '/members/invite'], 'input' => ['shape' => 'InviteMembersRequest'], 'output' => ['shape' => 'InviteMembersResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException'], ['shape' => 'ResourceNotFoundException']]], 'ListEnabledProductsForImport' => ['name' => 'ListEnabledProductsForImport', 'http' => ['method' => 'GET', 'requestUri' => '/productSubscriptions'], 'input' => ['shape' => 'ListEnabledProductsForImportRequest'], 'output' => ['shape' => 'ListEnabledProductsForImportResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'LimitExceededException'], ['shape' => 'InvalidAccessException']]], 'ListInvitations' => ['name' => 'ListInvitations', 'http' => ['method' => 'GET', 'requestUri' => '/invitations'], 'input' => ['shape' => 'ListInvitationsRequest'], 'output' => ['shape' => 'ListInvitationsResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException']]], 'ListMembers' => ['name' => 'ListMembers', 'http' => ['method' => 'GET', 'requestUri' => '/members'], 'input' => ['shape' => 'ListMembersRequest'], 'output' => ['shape' => 'ListMembersResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException']]], 'ListTagsForResource' => ['name' => 'ListTagsForResource', 'http' => ['method' => 'GET', 'requestUri' => '/tags/{ResourceArn}'], 'input' => ['shape' => 'ListTagsForResourceRequest'], 'output' => ['shape' => 'ListTagsForResourceResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'ResourceNotFoundException']]], 'TagResource' => ['name' => 'TagResource', 'http' => ['method' => 'POST', 'requestUri' => '/tags/{ResourceArn}'], 'input' => ['shape' => 'TagResourceRequest'], 'output' => ['shape' => 'TagResourceResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'ResourceNotFoundException']]], 'UntagResource' => ['name' => 'UntagResource', 'http' => ['method' => 'DELETE', 'requestUri' => '/tags/{ResourceArn}'], 'input' => ['shape' => 'UntagResourceRequest'], 'output' => ['shape' => 'UntagResourceResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'ResourceNotFoundException']]], 'UpdateActionTarget' => ['name' => 'UpdateActionTarget', 'http' => ['method' => 'PATCH', 'requestUri' => '/actionTargets/{ActionTargetArn+}'], 'input' => ['shape' => 'UpdateActionTargetRequest'], 'output' => ['shape' => 'UpdateActionTargetResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'ResourceNotFoundException'], ['shape' => 'InvalidAccessException'], ['shape' => 'ResourceNotFoundException']]], 'UpdateFindings' => ['name' => 'UpdateFindings', 'http' => ['method' => 'PATCH', 'requestUri' => '/findings'], 'input' => ['shape' => 'UpdateFindingsRequest'], 'output' => ['shape' => 'UpdateFindingsResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'LimitExceededException'], ['shape' => 'InvalidAccessException'], ['shape' => 'ResourceNotFoundException']]], 'UpdateInsight' => ['name' => 'UpdateInsight', 'http' => ['method' => 'PATCH', 'requestUri' => '/insights/{InsightArn+}'], 'input' => ['shape' => 'UpdateInsightRequest'], 'output' => ['shape' => 'UpdateInsightResponse'], 'errors' => [['shape' => 'InternalException'], ['shape' => 'InvalidInputException'], ['shape' => 'InvalidAccessException'], ['shape' => 'LimitExceededException'], ['shape' => 'ResourceNotFoundException']]]], 'shapes' => ['AcceptInvitationRequest' => ['type' => 'structure', 'required' => ['MasterId', 'InvitationId'], 'members' => ['MasterId' => ['shape' => 'NonEmptyString'], 'InvitationId' => ['shape' => 'NonEmptyString']]], 'AcceptInvitationResponse' => ['type' => 'structure', 'members' => []], 'AccessDeniedException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'NonEmptyString'], 'Code' => ['shape' => 'NonEmptyString']], 'error' => ['httpStatusCode' => 403], 'exception' => \true], 'AccountDetails' => ['type' => 'structure', 'members' => ['AccountId' => ['shape' => 'AccountId'], 'Email' => ['shape' => 'NonEmptyString']]], 'AccountDetailsList' => ['type' => 'list', 'member' => ['shape' => 'AccountDetails']], 'AccountId' => ['type' => 'string'], 'AccountIdList' => ['type' => 'list', 'member' => ['shape' => 'NonEmptyString']], 'ActionTarget' => ['type' => 'structure', 'required' => ['ActionTargetArn', 'Name', 'Description'], 'members' => ['ActionTargetArn' => ['shape' => 'NonEmptyString'], 'Name' => ['shape' => 'NonEmptyString'], 'Description' => ['shape' => 'NonEmptyString']]], 'ActionTargetList' => ['type' => 'list', 'member' => ['shape' => 'ActionTarget']], 'ArnList' => ['type' => 'list', 'member' => ['shape' => 'NonEmptyString']], 'AvailabilityZone' => ['type' => 'structure', 'members' => ['ZoneName' => ['shape' => 'NonEmptyString'], 'SubnetId' => ['shape' => 'NonEmptyString']]], 'AvailabilityZones' => ['type' => 'list', 'member' => ['shape' => 'AvailabilityZone']], 'AwsCloudFrontDistributionDetails' => ['type' => 'structure', 'members' => ['DomainName' => ['shape' => 'NonEmptyString'], 'ETag' => ['shape' => 'NonEmptyString'], 'LastModifiedTime' => ['shape' => 'NonEmptyString'], 'Logging' => ['shape' => 'AwsCloudFrontDistributionLogging'], 'Origins' => ['shape' => 'AwsCloudFrontDistributionOrigins'], 'Status' => ['shape' => 'NonEmptyString'], 'WebAclId' => ['shape' => 'NonEmptyString']]], 'AwsCloudFrontDistributionLogging' => ['type' => 'structure', 'members' => ['Bucket' => ['shape' => 'NonEmptyString'], 'Enabled' => ['shape' => 'Boolean'], 'IncludeCookies' => ['shape' => 'Boolean'], 'Prefix' => ['shape' => 'NonEmptyString']]], 'AwsCloudFrontDistributionOriginItem' => ['type' => 'structure', 'members' => ['DomainName' => ['shape' => 'NonEmptyString'], 'Id' => ['shape' => 'NonEmptyString'], 'OriginPath' => ['shape' => 'NonEmptyString']]], 'AwsCloudFrontDistributionOriginItemList' => ['type' => 'list', 'member' => ['shape' => 'AwsCloudFrontDistributionOriginItem']], 'AwsCloudFrontDistributionOrigins' => ['type' => 'structure', 'members' => ['Items' => ['shape' => 'AwsCloudFrontDistributionOriginItemList']]], 'AwsEc2InstanceDetails' => ['type' => 'structure', 'members' => ['Type' => ['shape' => 'NonEmptyString'], 'ImageId' => ['shape' => 'NonEmptyString'], 'IpV4Addresses' => ['shape' => 'StringList'], 'IpV6Addresses' => ['shape' => 'StringList'], 'KeyName' => ['shape' => 'NonEmptyString'], 'IamInstanceProfileArn' => ['shape' => 'NonEmptyString'], 'VpcId' => ['shape' => 'NonEmptyString'], 'SubnetId' => ['shape' => 'NonEmptyString'], 'LaunchedAt' => ['shape' => 'NonEmptyString']]], 'AwsElbv2LoadBalancerDetails' => ['type' => 'structure', 'members' => ['AvailabilityZones' => ['shape' => 'AvailabilityZones'], 'CanonicalHostedZoneId' => ['shape' => 'NonEmptyString'], 'CreatedTime' => ['shape' => 'NonEmptyString'], 'DNSName' => ['shape' => 'NonEmptyString'], 'IpAddressType' => ['shape' => 'NonEmptyString'], 'Scheme' => ['shape' => 'NonEmptyString'], 'SecurityGroups' => ['shape' => 'SecurityGroups'], 'State' => ['shape' => 'LoadBalancerState'], 'Type' => ['shape' => 'NonEmptyString'], 'VpcId' => ['shape' => 'NonEmptyString']]], 'AwsIamAccessKeyDetails' => ['type' => 'structure', 'members' => ['UserName' => ['shape' => 'NonEmptyString', 'deprecated' => \true, 'deprecatedMessage' => 'This field is deprecated, use PrincipalName instead.'], 'Status' => ['shape' => 'AwsIamAccessKeyStatus'], 'CreatedAt' => ['shape' => 'NonEmptyString'], 'PrincipalId' => ['shape' => 'NonEmptyString'], 'PrincipalType' => ['shape' => 'NonEmptyString'], 'PrincipalName' => ['shape' => 'NonEmptyString']]], 'AwsIamAccessKeyStatus' => ['type' => 'string', 'enum' => ['Active', 'Inactive']], 'AwsIamRoleAssumeRolePolicyDocument' => ['type' => 'string', 'max' => 131072, 'min' => 1, 'pattern' => '[\\u0009\\u000A\\u000D\\u0020-\\u007E\\u00A1-\\u00FF]+'], 'AwsIamRoleDetails' => ['type' => 'structure', 'members' => ['AssumeRolePolicyDocument' => ['shape' => 'AwsIamRoleAssumeRolePolicyDocument'], 'CreateDate' => ['shape' => 'NonEmptyString'], 'RoleId' => ['shape' => 'NonEmptyString'], 'RoleName' => ['shape' => 'NonEmptyString'], 'MaxSessionDuration' => ['shape' => 'Integer'], 'Path' => ['shape' => 'NonEmptyString']]], 'AwsKmsKeyDetails' => ['type' => 'structure', 'members' => ['AWSAccountId' => ['shape' => 'NonEmptyString'], 'CreationDate' => ['shape' => 'Double'], 'KeyId' => ['shape' => 'NonEmptyString'], 'KeyManager' => ['shape' => 'NonEmptyString'], 'KeyState' => ['shape' => 'NonEmptyString'], 'Origin' => ['shape' => 'NonEmptyString']]], 'AwsLambdaFunctionCode' => ['type' => 'structure', 'members' => ['S3Bucket' => ['shape' => 'NonEmptyString'], 'S3Key' => ['shape' => 'NonEmptyString'], 'S3ObjectVersion' => ['shape' => 'NonEmptyString'], 'ZipFile' => ['shape' => 'NonEmptyString']]], 'AwsLambdaFunctionDeadLetterConfig' => ['type' => 'structure', 'members' => ['TargetArn' => ['shape' => 'NonEmptyString']]], 'AwsLambdaFunctionDetails' => ['type' => 'structure', 'members' => ['Code' => ['shape' => 'AwsLambdaFunctionCode'], 'CodeSha256' => ['shape' => 'NonEmptyString'], 'DeadLetterConfig' => ['shape' => 'AwsLambdaFunctionDeadLetterConfig'], 'Environment' => ['shape' => 'AwsLambdaFunctionEnvironment'], 'FunctionName' => ['shape' => 'NonEmptyString'], 'Handler' => ['shape' => 'NonEmptyString'], 'KmsKeyArn' => ['shape' => 'NonEmptyString'], 'LastModified' => ['shape' => 'NonEmptyString'], 'Layers' => ['shape' => 'AwsLambdaFunctionLayerList'], 'MasterArn' => ['shape' => 'NonEmptyString'], 'MemorySize' => ['shape' => 'Integer'], 'RevisionId' => ['shape' => 'NonEmptyString'], 'Role' => ['shape' => 'NonEmptyString'], 'Runtime' => ['shape' => 'NonEmptyString'], 'Timeout' => ['shape' => 'Integer'], 'TracingConfig' => ['shape' => 'AwsLambdaFunctionTracingConfig'], 'VpcConfig' => ['shape' => 'AwsLambdaFunctionVpcConfig'], 'Version' => ['shape' => 'NonEmptyString']]], 'AwsLambdaFunctionEnvironment' => ['type' => 'structure', 'members' => ['Variables' => ['shape' => 'FieldMap'], 'Error' => ['shape' => 'AwsLambdaFunctionEnvironmentError']]], 'AwsLambdaFunctionEnvironmentError' => ['type' => 'structure', 'members' => ['ErrorCode' => ['shape' => 'NonEmptyString'], 'Message' => ['shape' => 'NonEmptyString']]], 'AwsLambdaFunctionLayer' => ['type' => 'structure', 'members' => ['Arn' => ['shape' => 'NonEmptyString'], 'CodeSize' => ['shape' => 'Integer']]], 'AwsLambdaFunctionLayerList' => ['type' => 'list', 'member' => ['shape' => 'AwsLambdaFunctionLayer']], 'AwsLambdaFunctionTracingConfig' => ['type' => 'structure', 'members' => ['Mode' => ['shape' => 'NonEmptyString']]], 'AwsLambdaFunctionVpcConfig' => ['type' => 'structure', 'members' => ['SecurityGroupIds' => ['shape' => 'NonEmptyStringList'], 'SubnetIds' => ['shape' => 'NonEmptyStringList'], 'VpcId' => ['shape' => 'NonEmptyString']]], 'AwsS3BucketDetails' => ['type' => 'structure', 'members' => ['OwnerId' => ['shape' => 'NonEmptyString'], 'OwnerName' => ['shape' => 'NonEmptyString']]], 'AwsSecurityFinding' => ['type' => 'structure', 'required' => ['SchemaVersion', 'Id', 'ProductArn', 'GeneratorId', 'AwsAccountId', 'Types', 'CreatedAt', 'UpdatedAt', 'Severity', 'Title', 'Description', 'Resources'], 'members' => ['SchemaVersion' => ['shape' => 'NonEmptyString'], 'Id' => ['shape' => 'NonEmptyString'], 'ProductArn' => ['shape' => 'NonEmptyString'], 'GeneratorId' => ['shape' => 'NonEmptyString'], 'AwsAccountId' => ['shape' => 'NonEmptyString'], 'Types' => ['shape' => 'TypeList'], 'FirstObservedAt' => ['shape' => 'NonEmptyString'], 'LastObservedAt' => ['shape' => 'NonEmptyString'], 'CreatedAt' => ['shape' => 'NonEmptyString'], 'UpdatedAt' => ['shape' => 'NonEmptyString'], 'Severity' => ['shape' => 'Severity'], 'Confidence' => ['shape' => 'Integer'], 'Criticality' => ['shape' => 'Integer'], 'Title' => ['shape' => 'NonEmptyString'], 'Description' => ['shape' => 'NonEmptyString'], 'Remediation' => ['shape' => 'Remediation'], 'SourceUrl' => ['shape' => 'NonEmptyString'], 'ProductFields' => ['shape' => 'FieldMap'], 'UserDefinedFields' => ['shape' => 'FieldMap'], 'Malware' => ['shape' => 'MalwareList'], 'Network' => ['shape' => 'Network'], 'Process' => ['shape' => 'ProcessDetails'], 'ThreatIntelIndicators' => ['shape' => 'ThreatIntelIndicatorList'], 'Resources' => ['shape' => 'ResourceList'], 'Compliance' => ['shape' => 'Compliance'], 'VerificationState' => ['shape' => 'VerificationState'], 'WorkflowState' => ['shape' => 'WorkflowState'], 'RecordState' => ['shape' => 'RecordState'], 'RelatedFindings' => ['shape' => 'RelatedFindingList'], 'Note' => ['shape' => 'Note']]], 'AwsSecurityFindingFilters' => ['type' => 'structure', 'members' => ['ProductArn' => ['shape' => 'StringFilterList'], 'AwsAccountId' => ['shape' => 'StringFilterList'], 'Id' => ['shape' => 'StringFilterList'], 'GeneratorId' => ['shape' => 'StringFilterList'], 'Type' => ['shape' => 'StringFilterList'], 'FirstObservedAt' => ['shape' => 'DateFilterList'], 'LastObservedAt' => ['shape' => 'DateFilterList'], 'CreatedAt' => ['shape' => 'DateFilterList'], 'UpdatedAt' => ['shape' => 'DateFilterList'], 'SeverityProduct' => ['shape' => 'NumberFilterList'], 'SeverityNormalized' => ['shape' => 'NumberFilterList'], 'SeverityLabel' => ['shape' => 'StringFilterList'], 'Confidence' => ['shape' => 'NumberFilterList'], 'Criticality' => ['shape' => 'NumberFilterList'], 'Title' => ['shape' => 'StringFilterList'], 'Description' => ['shape' => 'StringFilterList'], 'RecommendationText' => ['shape' => 'StringFilterList'], 'SourceUrl' => ['shape' => 'StringFilterList'], 'ProductFields' => ['shape' => 'MapFilterList'], 'ProductName' => ['shape' => 'StringFilterList'], 'CompanyName' => ['shape' => 'StringFilterList'], 'UserDefinedFields' => ['shape' => 'MapFilterList'], 'MalwareName' => ['shape' => 'StringFilterList'], 'MalwareType' => ['shape' => 'StringFilterList'], 'MalwarePath' => ['shape' => 'StringFilterList'], 'MalwareState' => ['shape' => 'StringFilterList'], 'NetworkDirection' => ['shape' => 'StringFilterList'], 'NetworkProtocol' => ['shape' => 'StringFilterList'], 'NetworkSourceIpV4' => ['shape' => 'IpFilterList'], 'NetworkSourceIpV6' => ['shape' => 'IpFilterList'], 'NetworkSourcePort' => ['shape' => 'NumberFilterList'], 'NetworkSourceDomain' => ['shape' => 'StringFilterList'], 'NetworkSourceMac' => ['shape' => 'StringFilterList'], 'NetworkDestinationIpV4' => ['shape' => 'IpFilterList'], 'NetworkDestinationIpV6' => ['shape' => 'IpFilterList'], 'NetworkDestinationPort' => ['shape' => 'NumberFilterList'], 'NetworkDestinationDomain' => ['shape' => 'StringFilterList'], 'ProcessName' => ['shape' => 'StringFilterList'], 'ProcessPath' => ['shape' => 'StringFilterList'], 'ProcessPid' => ['shape' => 'NumberFilterList'], 'ProcessParentPid' => ['shape' => 'NumberFilterList'], 'ProcessLaunchedAt' => ['shape' => 'DateFilterList'], 'ProcessTerminatedAt' => ['shape' => 'DateFilterList'], 'ThreatIntelIndicatorType' => ['shape' => 'StringFilterList'], 'ThreatIntelIndicatorValue' => ['shape' => 'StringFilterList'], 'ThreatIntelIndicatorCategory' => ['shape' => 'StringFilterList'], 'ThreatIntelIndicatorLastObservedAt' => ['shape' => 'DateFilterList'], 'ThreatIntelIndicatorSource' => ['shape' => 'StringFilterList'], 'ThreatIntelIndicatorSourceUrl' => ['shape' => 'StringFilterList'], 'ResourceType' => ['shape' => 'StringFilterList'], 'ResourceId' => ['shape' => 'StringFilterList'], 'ResourcePartition' => ['shape' => 'StringFilterList'], 'ResourceRegion' => ['shape' => 'StringFilterList'], 'ResourceTags' => ['shape' => 'MapFilterList'], 'ResourceAwsEc2InstanceType' => ['shape' => 'StringFilterList'], 'ResourceAwsEc2InstanceImageId' => ['shape' => 'StringFilterList'], 'ResourceAwsEc2InstanceIpV4Addresses' => ['shape' => 'IpFilterList'], 'ResourceAwsEc2InstanceIpV6Addresses' => ['shape' => 'IpFilterList'], 'ResourceAwsEc2InstanceKeyName' => ['shape' => 'StringFilterList'], 'ResourceAwsEc2InstanceIamInstanceProfileArn' => ['shape' => 'StringFilterList'], 'ResourceAwsEc2InstanceVpcId' => ['shape' => 'StringFilterList'], 'ResourceAwsEc2InstanceSubnetId' => ['shape' => 'StringFilterList'], 'ResourceAwsEc2InstanceLaunchedAt' => ['shape' => 'DateFilterList'], 'ResourceAwsS3BucketOwnerId' => ['shape' => 'StringFilterList'], 'ResourceAwsS3BucketOwnerName' => ['shape' => 'StringFilterList'], 'ResourceAwsIamAccessKeyUserName' => ['shape' => 'StringFilterList'], 'ResourceAwsIamAccessKeyStatus' => ['shape' => 'StringFilterList'], 'ResourceAwsIamAccessKeyCreatedAt' => ['shape' => 'DateFilterList'], 'ResourceContainerName' => ['shape' => 'StringFilterList'], 'ResourceContainerImageId' => ['shape' => 'StringFilterList'], 'ResourceContainerImageName' => ['shape' => 'StringFilterList'], 'ResourceContainerLaunchedAt' => ['shape' => 'DateFilterList'], 'ResourceDetailsOther' => ['shape' => 'MapFilterList'], 'ComplianceStatus' => ['shape' => 'StringFilterList'], 'VerificationState' => ['shape' => 'StringFilterList'], 'WorkflowState' => ['shape' => 'StringFilterList'], 'RecordState' => ['shape' => 'StringFilterList'], 'RelatedFindingsProductArn' => ['shape' => 'StringFilterList'], 'RelatedFindingsId' => ['shape' => 'StringFilterList'], 'NoteText' => ['shape' => 'StringFilterList'], 'NoteUpdatedAt' => ['shape' => 'DateFilterList'], 'NoteUpdatedBy' => ['shape' => 'StringFilterList'], 'Keyword' => ['shape' => 'KeywordFilterList']]], 'AwsSecurityFindingList' => ['type' => 'list', 'member' => ['shape' => 'AwsSecurityFinding']], 'AwsSnsTopicDetails' => ['type' => 'structure', 'members' => ['KmsMasterKeyId' => ['shape' => 'NonEmptyString'], 'Subscription' => ['shape' => 'AwsSnsTopicSubscriptionList'], 'TopicName' => ['shape' => 'NonEmptyString'], 'Owner' => ['shape' => 'NonEmptyString']]], 'AwsSnsTopicSubscription' => ['type' => 'structure', 'members' => ['Endpoint' => ['shape' => 'NonEmptyString'], 'Protocol' => ['shape' => 'NonEmptyString']]], 'AwsSnsTopicSubscriptionList' => ['type' => 'list', 'member' => ['shape' => 'AwsSnsTopicSubscription']], 'AwsSqsQueueDetails' => ['type' => 'structure', 'members' => ['KmsDataKeyReusePeriodSeconds' => ['shape' => 'Integer'], 'KmsMasterKeyId' => ['shape' => 'NonEmptyString'], 'QueueName' => ['shape' => 'NonEmptyString'], 'DeadLetterTargetArn' => ['shape' => 'NonEmptyString']]], 'BatchDisableStandardsRequest' => ['type' => 'structure', 'required' => ['StandardsSubscriptionArns'], 'members' => ['StandardsSubscriptionArns' => ['shape' => 'StandardsSubscriptionArns']]], 'BatchDisableStandardsResponse' => ['type' => 'structure', 'members' => ['StandardsSubscriptions' => ['shape' => 'StandardsSubscriptions']]], 'BatchEnableStandardsRequest' => ['type' => 'structure', 'required' => ['StandardsSubscriptionRequests'], 'members' => ['StandardsSubscriptionRequests' => ['shape' => 'StandardsSubscriptionRequests']]], 'BatchEnableStandardsResponse' => ['type' => 'structure', 'members' => ['StandardsSubscriptions' => ['shape' => 'StandardsSubscriptions']]], 'BatchImportFindingsRequest' => ['type' => 'structure', 'required' => ['Findings'], 'members' => ['Findings' => ['shape' => 'AwsSecurityFindingList']]], 'BatchImportFindingsResponse' => ['type' => 'structure', 'required' => ['FailedCount', 'SuccessCount'], 'members' => ['FailedCount' => ['shape' => 'Integer'], 'SuccessCount' => ['shape' => 'Integer'], 'FailedFindings' => ['shape' => 'ImportFindingsErrorList']]], 'Boolean' => ['type' => 'boolean'], 'CategoryList' => ['type' => 'list', 'member' => ['shape' => 'NonEmptyString']], 'Compliance' => ['type' => 'structure', 'members' => ['Status' => ['shape' => 'ComplianceStatus']]], 'ComplianceStatus' => ['type' => 'string', 'enum' => ['PASSED', 'WARNING', 'FAILED', 'NOT_AVAILABLE']], 'ContainerDetails' => ['type' => 'structure', 'members' => ['Name' => ['shape' => 'NonEmptyString'], 'ImageId' => ['shape' => 'NonEmptyString'], 'ImageName' => ['shape' => 'NonEmptyString'], 'LaunchedAt' => ['shape' => 'NonEmptyString']]], 'CreateActionTargetRequest' => ['type' => 'structure', 'required' => ['Name', 'Description', 'Id'], 'members' => ['Name' => ['shape' => 'NonEmptyString'], 'Description' => ['shape' => 'NonEmptyString'], 'Id' => ['shape' => 'NonEmptyString']]], 'CreateActionTargetResponse' => ['type' => 'structure', 'required' => ['ActionTargetArn'], 'members' => ['ActionTargetArn' => ['shape' => 'NonEmptyString']]], 'CreateInsightRequest' => ['type' => 'structure', 'required' => ['Name', 'Filters', 'GroupByAttribute'], 'members' => ['Name' => ['shape' => 'NonEmptyString'], 'Filters' => ['shape' => 'AwsSecurityFindingFilters'], 'GroupByAttribute' => ['shape' => 'NonEmptyString']]], 'CreateInsightResponse' => ['type' => 'structure', 'required' => ['InsightArn'], 'members' => ['InsightArn' => ['shape' => 'NonEmptyString']]], 'CreateMembersRequest' => ['type' => 'structure', 'members' => ['AccountDetails' => ['shape' => 'AccountDetailsList']]], 'CreateMembersResponse' => ['type' => 'structure', 'members' => ['UnprocessedAccounts' => ['shape' => 'ResultList']]], 'DateFilter' => ['type' => 'structure', 'members' => ['Start' => ['shape' => 'NonEmptyString'], 'End' => ['shape' => 'NonEmptyString'], 'DateRange' => ['shape' => 'DateRange']]], 'DateFilterList' => ['type' => 'list', 'member' => ['shape' => 'DateFilter']], 'DateRange' => ['type' => 'structure', 'members' => ['Value' => ['shape' => 'Integer'], 'Unit' => ['shape' => 'DateRangeUnit']]], 'DateRangeUnit' => ['type' => 'string', 'enum' => ['DAYS']], 'DeclineInvitationsRequest' => ['type' => 'structure', 'required' => ['AccountIds'], 'members' => ['AccountIds' => ['shape' => 'AccountIdList']]], 'DeclineInvitationsResponse' => ['type' => 'structure', 'members' => ['UnprocessedAccounts' => ['shape' => 'ResultList']]], 'DeleteActionTargetRequest' => ['type' => 'structure', 'required' => ['ActionTargetArn'], 'members' => ['ActionTargetArn' => ['shape' => 'NonEmptyString', 'location' => 'uri', 'locationName' => 'ActionTargetArn']]], 'DeleteActionTargetResponse' => ['type' => 'structure', 'required' => ['ActionTargetArn'], 'members' => ['ActionTargetArn' => ['shape' => 'NonEmptyString']]], 'DeleteInsightRequest' => ['type' => 'structure', 'required' => ['InsightArn'], 'members' => ['InsightArn' => ['shape' => 'NonEmptyString', 'location' => 'uri', 'locationName' => 'InsightArn']]], 'DeleteInsightResponse' => ['type' => 'structure', 'required' => ['InsightArn'], 'members' => ['InsightArn' => ['shape' => 'NonEmptyString']]], 'DeleteInvitationsRequest' => ['type' => 'structure', 'required' => ['AccountIds'], 'members' => ['AccountIds' => ['shape' => 'AccountIdList']]], 'DeleteInvitationsResponse' => ['type' => 'structure', 'members' => ['UnprocessedAccounts' => ['shape' => 'ResultList']]], 'DeleteMembersRequest' => ['type' => 'structure', 'members' => ['AccountIds' => ['shape' => 'AccountIdList']]], 'DeleteMembersResponse' => ['type' => 'structure', 'members' => ['UnprocessedAccounts' => ['shape' => 'ResultList']]], 'DescribeActionTargetsRequest' => ['type' => 'structure', 'members' => ['ActionTargetArns' => ['shape' => 'ArnList'], 'NextToken' => ['shape' => 'NextToken'], 'MaxResults' => ['shape' => 'MaxResults']]], 'DescribeActionTargetsResponse' => ['type' => 'structure', 'required' => ['ActionTargets'], 'members' => ['ActionTargets' => ['shape' => 'ActionTargetList'], 'NextToken' => ['shape' => 'NextToken']]], 'DescribeHubRequest' => ['type' => 'structure', 'members' => ['HubArn' => ['shape' => 'NonEmptyString', 'location' => 'querystring', 'locationName' => 'HubArn']]], 'DescribeHubResponse' => ['type' => 'structure', 'members' => ['HubArn' => ['shape' => 'NonEmptyString'], 'SubscribedAt' => ['shape' => 'NonEmptyString']]], 'DescribeProductsRequest' => ['type' => 'structure', 'members' => ['NextToken' => ['shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken'], 'MaxResults' => ['shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults']]], 'DescribeProductsResponse' => ['type' => 'structure', 'required' => ['Products'], 'members' => ['Products' => ['shape' => 'ProductsList'], 'NextToken' => ['shape' => 'NextToken']]], 'DisableImportFindingsForProductRequest' => ['type' => 'structure', 'required' => ['ProductSubscriptionArn'], 'members' => ['ProductSubscriptionArn' => ['shape' => 'NonEmptyString', 'location' => 'uri', 'locationName' => 'ProductSubscriptionArn']]], 'DisableImportFindingsForProductResponse' => ['type' => 'structure', 'members' => []], 'DisableSecurityHubRequest' => ['type' => 'structure', 'members' => []], 'DisableSecurityHubResponse' => ['type' => 'structure', 'members' => []], 'DisassociateFromMasterAccountRequest' => ['type' => 'structure', 'members' => []], 'DisassociateFromMasterAccountResponse' => ['type' => 'structure', 'members' => []], 'DisassociateMembersRequest' => ['type' => 'structure', 'members' => ['AccountIds' => ['shape' => 'AccountIdList']]], 'DisassociateMembersResponse' => ['type' => 'structure', 'members' => []], 'Double' => ['type' => 'double'], 'EnableImportFindingsForProductRequest' => ['type' => 'structure', 'required' => ['ProductArn'], 'members' => ['ProductArn' => ['shape' => 'NonEmptyString']]], 'EnableImportFindingsForProductResponse' => ['type' => 'structure', 'members' => ['ProductSubscriptionArn' => ['shape' => 'NonEmptyString']]], 'EnableSecurityHubRequest' => ['type' => 'structure', 'members' => ['Tags' => ['shape' => 'TagMap']]], 'EnableSecurityHubResponse' => ['type' => 'structure', 'members' => []], 'FieldMap' => ['type' => 'map', 'key' => ['shape' => 'NonEmptyString'], 'value' => ['shape' => 'NonEmptyString']], 'GetEnabledStandardsRequest' => ['type' => 'structure', 'members' => ['StandardsSubscriptionArns' => ['shape' => 'StandardsSubscriptionArns'], 'NextToken' => ['shape' => 'NextToken'], 'MaxResults' => ['shape' => 'MaxResults']]], 'GetEnabledStandardsResponse' => ['type' => 'structure', 'members' => ['StandardsSubscriptions' => ['shape' => 'StandardsSubscriptions'], 'NextToken' => ['shape' => 'NextToken']]], 'GetFindingsRequest' => ['type' => 'structure', 'members' => ['Filters' => ['shape' => 'AwsSecurityFindingFilters'], 'SortCriteria' => ['shape' => 'SortCriteria'], 'NextToken' => ['shape' => 'NextToken'], 'MaxResults' => ['shape' => 'MaxResults']]], 'GetFindingsResponse' => ['type' => 'structure', 'required' => ['Findings'], 'members' => ['Findings' => ['shape' => 'AwsSecurityFindingList'], 'NextToken' => ['shape' => 'NextToken']]], 'GetInsightResultsRequest' => ['type' => 'structure', 'required' => ['InsightArn'], 'members' => ['InsightArn' => ['shape' => 'NonEmptyString', 'location' => 'uri', 'locationName' => 'InsightArn']]], 'GetInsightResultsResponse' => ['type' => 'structure', 'required' => ['InsightResults'], 'members' => ['InsightResults' => ['shape' => 'InsightResults']]], 'GetInsightsRequest' => ['type' => 'structure', 'members' => ['InsightArns' => ['shape' => 'ArnList'], 'NextToken' => ['shape' => 'NextToken'], 'MaxResults' => ['shape' => 'MaxResults']]], 'GetInsightsResponse' => ['type' => 'structure', 'required' => ['Insights'], 'members' => ['Insights' => ['shape' => 'InsightList'], 'NextToken' => ['shape' => 'NextToken']]], 'GetInvitationsCountRequest' => ['type' => 'structure', 'members' => []], 'GetInvitationsCountResponse' => ['type' => 'structure', 'members' => ['InvitationsCount' => ['shape' => 'Integer']]], 'GetMasterAccountRequest' => ['type' => 'structure', 'members' => []], 'GetMasterAccountResponse' => ['type' => 'structure', 'members' => ['Master' => ['shape' => 'Invitation']]], 'GetMembersRequest' => ['type' => 'structure', 'required' => ['AccountIds'], 'members' => ['AccountIds' => ['shape' => 'AccountIdList']]], 'GetMembersResponse' => ['type' => 'structure', 'members' => ['Members' => ['shape' => 'MemberList'], 'UnprocessedAccounts' => ['shape' => 'ResultList']]], 'ImportFindingsError' => ['type' => 'structure', 'required' => ['Id', 'ErrorCode', 'ErrorMessage'], 'members' => ['Id' => ['shape' => 'NonEmptyString'], 'ErrorCode' => ['shape' => 'NonEmptyString'], 'ErrorMessage' => ['shape' => 'NonEmptyString']]], 'ImportFindingsErrorList' => ['type' => 'list', 'member' => ['shape' => 'ImportFindingsError']], 'Insight' => ['type' => 'structure', 'required' => ['InsightArn', 'Name', 'Filters', 'GroupByAttribute'], 'members' => ['InsightArn' => ['shape' => 'NonEmptyString'], 'Name' => ['shape' => 'NonEmptyString'], 'Filters' => ['shape' => 'AwsSecurityFindingFilters'], 'GroupByAttribute' => ['shape' => 'NonEmptyString']]], 'InsightList' => ['type' => 'list', 'member' => ['shape' => 'Insight']], 'InsightResultValue' => ['type' => 'structure', 'required' => ['GroupByAttributeValue', 'Count'], 'members' => ['GroupByAttributeValue' => ['shape' => 'NonEmptyString'], 'Count' => ['shape' => 'Integer']]], 'InsightResultValueList' => ['type' => 'list', 'member' => ['shape' => 'InsightResultValue']], 'InsightResults' => ['type' => 'structure', 'required' => ['InsightArn', 'GroupByAttribute', 'ResultValues'], 'members' => ['InsightArn' => ['shape' => 'NonEmptyString'], 'GroupByAttribute' => ['shape' => 'NonEmptyString'], 'ResultValues' => ['shape' => 'InsightResultValueList']]], 'Integer' => ['type' => 'integer'], 'InternalException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'NonEmptyString'], 'Code' => ['shape' => 'NonEmptyString']], 'error' => ['httpStatusCode' => 500], 'exception' => \true], 'InvalidAccessException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'NonEmptyString'], 'Code' => ['shape' => 'NonEmptyString']], 'error' => ['httpStatusCode' => 401], 'exception' => \true], 'InvalidInputException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'NonEmptyString'], 'Code' => ['shape' => 'NonEmptyString']], 'error' => ['httpStatusCode' => 400], 'exception' => \true], 'Invitation' => ['type' => 'structure', 'members' => ['AccountId' => ['shape' => 'AccountId'], 'InvitationId' => ['shape' => 'NonEmptyString'], 'InvitedAt' => ['shape' => 'Timestamp'], 'MemberStatus' => ['shape' => 'NonEmptyString']]], 'InvitationList' => ['type' => 'list', 'member' => ['shape' => 'Invitation']], 'InviteMembersRequest' => ['type' => 'structure', 'members' => ['AccountIds' => ['shape' => 'AccountIdList']]], 'InviteMembersResponse' => ['type' => 'structure', 'members' => ['UnprocessedAccounts' => ['shape' => 'ResultList']]], 'IpFilter' => ['type' => 'structure', 'members' => ['Cidr' => ['shape' => 'NonEmptyString']]], 'IpFilterList' => ['type' => 'list', 'member' => ['shape' => 'IpFilter']], 'KeywordFilter' => ['type' => 'structure', 'members' => ['Value' => ['shape' => 'NonEmptyString']]], 'KeywordFilterList' => ['type' => 'list', 'member' => ['shape' => 'KeywordFilter']], 'LimitExceededException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'NonEmptyString'], 'Code' => ['shape' => 'NonEmptyString']], 'error' => ['httpStatusCode' => 429], 'exception' => \true], 'ListEnabledProductsForImportRequest' => ['type' => 'structure', 'members' => ['NextToken' => ['shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken'], 'MaxResults' => ['shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults']]], 'ListEnabledProductsForImportResponse' => ['type' => 'structure', 'members' => ['ProductSubscriptions' => ['shape' => 'ProductSubscriptionArnList'], 'NextToken' => ['shape' => 'NextToken']]], 'ListInvitationsRequest' => ['type' => 'structure', 'members' => ['MaxResults' => ['shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults'], 'NextToken' => ['shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken']]], 'ListInvitationsResponse' => ['type' => 'structure', 'members' => ['Invitations' => ['shape' => 'InvitationList'], 'NextToken' => ['shape' => 'NonEmptyString']]], 'ListMembersRequest' => ['type' => 'structure', 'members' => ['OnlyAssociated' => ['shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'OnlyAssociated'], 'MaxResults' => ['shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults'], 'NextToken' => ['shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken']]], 'ListMembersResponse' => ['type' => 'structure', 'members' => ['Members' => ['shape' => 'MemberList'], 'NextToken' => ['shape' => 'NonEmptyString']]], 'ListTagsForResourceRequest' => ['type' => 'structure', 'required' => ['ResourceArn'], 'members' => ['ResourceArn' => ['shape' => 'ResourceArn', 'location' => 'uri', 'locationName' => 'ResourceArn']]], 'ListTagsForResourceResponse' => ['type' => 'structure', 'members' => ['Tags' => ['shape' => 'TagMap']]], 'LoadBalancerState' => ['type' => 'structure', 'members' => ['Code' => ['shape' => 'NonEmptyString'], 'Reason' => ['shape' => 'NonEmptyString']]], 'Malware' => ['type' => 'structure', 'required' => ['Name'], 'members' => ['Name' => ['shape' => 'NonEmptyString'], 'Type' => ['shape' => 'MalwareType'], 'Path' => ['shape' => 'NonEmptyString'], 'State' => ['shape' => 'MalwareState']]], 'MalwareList' => ['type' => 'list', 'member' => ['shape' => 'Malware']], 'MalwareState' => ['type' => 'string', 'enum' => ['OBSERVED', 'REMOVAL_FAILED', 'REMOVED']], 'MalwareType' => ['type' => 'string', 'enum' => ['ADWARE', 'BLENDED_THREAT', 'BOTNET_AGENT', 'COIN_MINER', 'EXPLOIT_KIT', 'KEYLOGGER', 'MACRO', 'POTENTIALLY_UNWANTED', 'SPYWARE', 'RANSOMWARE', 'REMOTE_ACCESS', 'ROOTKIT', 'TROJAN', 'VIRUS', 'WORM']], 'MapFilter' => ['type' => 'structure', 'members' => ['Key' => ['shape' => 'NonEmptyString'], 'Value' => ['shape' => 'NonEmptyString'], 'Comparison' => ['shape' => 'MapFilterComparison']]], 'MapFilterComparison' => ['type' => 'string', 'enum' => ['EQUALS']], 'MapFilterList' => ['type' => 'list', 'member' => ['shape' => 'MapFilter']], 'MaxResults' => ['type' => 'integer', 'max' => 100, 'min' => 1], 'Member' => ['type' => 'structure', 'members' => ['AccountId' => ['shape' => 'AccountId'], 'Email' => ['shape' => 'NonEmptyString'], 'MasterId' => ['shape' => 'NonEmptyString'], 'MemberStatus' => ['shape' => 'NonEmptyString'], 'InvitedAt' => ['shape' => 'Timestamp'], 'UpdatedAt' => ['shape' => 'Timestamp']]], 'MemberList' => ['type' => 'list', 'member' => ['shape' => 'Member']], 'Network' => ['type' => 'structure', 'members' => ['Direction' => ['shape' => 'NetworkDirection'], 'Protocol' => ['shape' => 'NonEmptyString'], 'SourceIpV4' => ['shape' => 'NonEmptyString'], 'SourceIpV6' => ['shape' => 'NonEmptyString'], 'SourcePort' => ['shape' => 'Integer'], 'SourceDomain' => ['shape' => 'NonEmptyString'], 'SourceMac' => ['shape' => 'NonEmptyString'], 'DestinationIpV4' => ['shape' => 'NonEmptyString'], 'DestinationIpV6' => ['shape' => 'NonEmptyString'], 'DestinationPort' => ['shape' => 'Integer'], 'DestinationDomain' => ['shape' => 'NonEmptyString']]], 'NetworkDirection' => ['type' => 'string', 'enum' => ['IN', 'OUT']], 'NextToken' => ['type' => 'string'], 'NonEmptyString' => ['type' => 'string', 'pattern' => '.*\\S.*'], 'NonEmptyStringList' => ['type' => 'list', 'member' => ['shape' => 'NonEmptyString']], 'Note' => ['type' => 'structure', 'required' => ['Text', 'UpdatedBy', 'UpdatedAt'], 'members' => ['Text' => ['shape' => 'NonEmptyString'], 'UpdatedBy' => ['shape' => 'NonEmptyString'], 'UpdatedAt' => ['shape' => 'NonEmptyString']]], 'NoteUpdate' => ['type' => 'structure', 'required' => ['Text', 'UpdatedBy'], 'members' => ['Text' => ['shape' => 'NonEmptyString'], 'UpdatedBy' => ['shape' => 'NonEmptyString']]], 'NumberFilter' => ['type' => 'structure', 'members' => ['Gte' => ['shape' => 'Double'], 'Lte' => ['shape' => 'Double'], 'Eq' => ['shape' => 'Double']]], 'NumberFilterList' => ['type' => 'list', 'member' => ['shape' => 'NumberFilter']], 'Partition' => ['type' => 'string', 'enum' => ['aws', 'aws-cn', 'aws-us-gov']], 'ProcessDetails' => ['type' => 'structure', 'members' => ['Name' => ['shape' => 'NonEmptyString'], 'Path' => ['shape' => 'NonEmptyString'], 'Pid' => ['shape' => 'Integer'], 'ParentPid' => ['shape' => 'Integer'], 'LaunchedAt' => ['shape' => 'NonEmptyString'], 'TerminatedAt' => ['shape' => 'NonEmptyString']]], 'Product' => ['type' => 'structure', 'required' => ['ProductArn'], 'members' => ['ProductArn' => ['shape' => 'NonEmptyString'], 'ProductName' => ['shape' => 'NonEmptyString'], 'CompanyName' => ['shape' => 'NonEmptyString'], 'Description' => ['shape' => 'NonEmptyString'], 'Categories' => ['shape' => 'CategoryList'], 'MarketplaceUrl' => ['shape' => 'NonEmptyString'], 'ActivationUrl' => ['shape' => 'NonEmptyString'], 'ProductSubscriptionResourcePolicy' => ['shape' => 'NonEmptyString']]], 'ProductSubscriptionArnList' => ['type' => 'list', 'member' => ['shape' => 'NonEmptyString']], 'ProductsList' => ['type' => 'list', 'member' => ['shape' => 'Product']], 'Recommendation' => ['type' => 'structure', 'members' => ['Text' => ['shape' => 'NonEmptyString'], 'Url' => ['shape' => 'NonEmptyString']]], 'RecordState' => ['type' => 'string', 'enum' => ['ACTIVE', 'ARCHIVED']], 'RelatedFinding' => ['type' => 'structure', 'required' => ['ProductArn', 'Id'], 'members' => ['ProductArn' => ['shape' => 'NonEmptyString'], 'Id' => ['shape' => 'NonEmptyString']]], 'RelatedFindingList' => ['type' => 'list', 'member' => ['shape' => 'RelatedFinding']], 'Remediation' => ['type' => 'structure', 'members' => ['Recommendation' => ['shape' => 'Recommendation']]], 'Resource' => ['type' => 'structure', 'required' => ['Type', 'Id'], 'members' => ['Type' => ['shape' => 'NonEmptyString'], 'Id' => ['shape' => 'NonEmptyString'], 'Partition' => ['shape' => 'Partition'], 'Region' => ['shape' => 'NonEmptyString'], 'Tags' => ['shape' => 'FieldMap'], 'Details' => ['shape' => 'ResourceDetails']]], 'ResourceArn' => ['type' => 'string', 'pattern' => '^arn:aws:securityhub:.*'], 'ResourceConflictException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'NonEmptyString'], 'Code' => ['shape' => 'NonEmptyString']], 'error' => ['httpStatusCode' => 409], 'exception' => \true], 'ResourceDetails' => ['type' => 'structure', 'members' => ['AwsCloudFrontDistribution' => ['shape' => 'AwsCloudFrontDistributionDetails'], 'AwsEc2Instance' => ['shape' => 'AwsEc2InstanceDetails'], 'AwsElbv2LoadBalancer' => ['shape' => 'AwsElbv2LoadBalancerDetails'], 'AwsS3Bucket' => ['shape' => 'AwsS3BucketDetails'], 'AwsIamAccessKey' => ['shape' => 'AwsIamAccessKeyDetails'], 'AwsIamRole' => ['shape' => 'AwsIamRoleDetails'], 'AwsKmsKey' => ['shape' => 'AwsKmsKeyDetails'], 'AwsLambdaFunction' => ['shape' => 'AwsLambdaFunctionDetails'], 'AwsSnsTopic' => ['shape' => 'AwsSnsTopicDetails'], 'AwsSqsQueue' => ['shape' => 'AwsSqsQueueDetails'], 'Container' => ['shape' => 'ContainerDetails'], 'Other' => ['shape' => 'FieldMap']]], 'ResourceList' => ['type' => 'list', 'member' => ['shape' => 'Resource']], 'ResourceNotFoundException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'NonEmptyString'], 'Code' => ['shape' => 'NonEmptyString']], 'error' => ['httpStatusCode' => 404], 'exception' => \true], 'Result' => ['type' => 'structure', 'members' => ['AccountId' => ['shape' => 'AccountId'], 'ProcessingResult' => ['shape' => 'NonEmptyString']]], 'ResultList' => ['type' => 'list', 'member' => ['shape' => 'Result']], 'SecurityGroups' => ['type' => 'list', 'member' => ['shape' => 'NonEmptyString']], 'Severity' => ['type' => 'structure', 'required' => ['Normalized'], 'members' => ['Product' => ['shape' => 'Double'], 'Normalized' => ['shape' => 'Integer']]], 'SortCriteria' => ['type' => 'list', 'member' => ['shape' => 'SortCriterion']], 'SortCriterion' => ['type' => 'structure', 'members' => ['Field' => ['shape' => 'NonEmptyString'], 'SortOrder' => ['shape' => 'SortOrder']]], 'SortOrder' => ['type' => 'string', 'enum' => ['asc', 'desc']], 'StandardsInputParameterMap' => ['type' => 'map', 'key' => ['shape' => 'NonEmptyString'], 'value' => ['shape' => 'NonEmptyString']], 'StandardsStatus' => ['type' => 'string', 'enum' => ['PENDING', 'READY', 'FAILED', 'DELETING', 'INCOMPLETE']], 'StandardsSubscription' => ['type' => 'structure', 'required' => ['StandardsSubscriptionArn', 'StandardsArn', 'StandardsInput', 'StandardsStatus'], 'members' => ['StandardsSubscriptionArn' => ['shape' => 'NonEmptyString'], 'StandardsArn' => ['shape' => 'NonEmptyString'], 'StandardsInput' => ['shape' => 'StandardsInputParameterMap'], 'StandardsStatus' => ['shape' => 'StandardsStatus']]], 'StandardsSubscriptionArns' => ['type' => 'list', 'member' => ['shape' => 'NonEmptyString'], 'max' => 25, 'min' => 1], 'StandardsSubscriptionRequest' => ['type' => 'structure', 'required' => ['StandardsArn'], 'members' => ['StandardsArn' => ['shape' => 'NonEmptyString'], 'StandardsInput' => ['shape' => 'StandardsInputParameterMap']]], 'StandardsSubscriptionRequests' => ['type' => 'list', 'member' => ['shape' => 'StandardsSubscriptionRequest'], 'max' => 25, 'min' => 1], 'StandardsSubscriptions' => ['type' => 'list', 'member' => ['shape' => 'StandardsSubscription']], 'StringFilter' => ['type' => 'structure', 'members' => ['Value' => ['shape' => 'NonEmptyString'], 'Comparison' => ['shape' => 'StringFilterComparison']]], 'StringFilterComparison' => ['type' => 'string', 'enum' => ['EQUALS', 'PREFIX']], 'StringFilterList' => ['type' => 'list', 'member' => ['shape' => 'StringFilter']], 'StringList' => ['type' => 'list', 'member' => ['shape' => 'NonEmptyString']], 'TagKey' => ['type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^(?!aws:)[a-zA-Z+-=._:/]+$'], 'TagKeyList' => ['type' => 'list', 'member' => ['shape' => 'TagKey'], 'max' => 50, 'min' => 1], 'TagMap' => ['type' => 'map', 'key' => ['shape' => 'TagKey'], 'value' => ['shape' => 'TagValue'], 'max' => 50, 'min' => 1], 'TagResourceRequest' => ['type' => 'structure', 'required' => ['ResourceArn', 'Tags'], 'members' => ['ResourceArn' => ['shape' => 'ResourceArn', 'location' => 'uri', 'locationName' => 'ResourceArn'], 'Tags' => ['shape' => 'TagMap']]], 'TagResourceResponse' => ['type' => 'structure', 'members' => []], 'TagValue' => ['type' => 'string', 'max' => 256], 'ThreatIntelIndicator' => ['type' => 'structure', 'members' => ['Type' => ['shape' => 'ThreatIntelIndicatorType'], 'Value' => ['shape' => 'NonEmptyString'], 'Category' => ['shape' => 'ThreatIntelIndicatorCategory'], 'LastObservedAt' => ['shape' => 'NonEmptyString'], 'Source' => ['shape' => 'NonEmptyString'], 'SourceUrl' => ['shape' => 'NonEmptyString']]], 'ThreatIntelIndicatorCategory' => ['type' => 'string', 'enum' => ['BACKDOOR', 'CARD_STEALER', 'COMMAND_AND_CONTROL', 'DROP_SITE', 'EXPLOIT_SITE', 'KEYLOGGER']], 'ThreatIntelIndicatorList' => ['type' => 'list', 'member' => ['shape' => 'ThreatIntelIndicator']], 'ThreatIntelIndicatorType' => ['type' => 'string', 'enum' => ['DOMAIN', 'EMAIL_ADDRESS', 'HASH_MD5', 'HASH_SHA1', 'HASH_SHA256', 'HASH_SHA512', 'IPV4_ADDRESS', 'IPV6_ADDRESS', 'MUTEX', 'PROCESS', 'URL']], 'Timestamp' => ['type' => 'timestamp', 'timestampFormat' => 'iso8601'], 'TypeList' => ['type' => 'list', 'member' => ['shape' => 'NonEmptyString']], 'UntagResourceRequest' => ['type' => 'structure', 'required' => ['ResourceArn', 'TagKeys'], 'members' => ['ResourceArn' => ['shape' => 'ResourceArn', 'location' => 'uri', 'locationName' => 'ResourceArn'], 'TagKeys' => ['shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys']]], 'UntagResourceResponse' => ['type' => 'structure', 'members' => []], 'UpdateActionTargetRequest' => ['type' => 'structure', 'required' => ['ActionTargetArn'], 'members' => ['ActionTargetArn' => ['shape' => 'NonEmptyString', 'location' => 'uri', 'locationName' => 'ActionTargetArn'], 'Name' => ['shape' => 'NonEmptyString'], 'Description' => ['shape' => 'NonEmptyString']]], 'UpdateActionTargetResponse' => ['type' => 'structure', 'members' => []], 'UpdateFindingsRequest' => ['type' => 'structure', 'required' => ['Filters'], 'members' => ['Filters' => ['shape' => 'AwsSecurityFindingFilters'], 'Note' => ['shape' => 'NoteUpdate'], 'RecordState' => ['shape' => 'RecordState']]], 'UpdateFindingsResponse' => ['type' => 'structure', 'members' => []], 'UpdateInsightRequest' => ['type' => 'structure', 'required' => ['InsightArn'], 'members' => ['InsightArn' => ['shape' => 'NonEmptyString', 'location' => 'uri', 'locationName' => 'InsightArn'], 'Name' => ['shape' => 'NonEmptyString'], 'Filters' => ['shape' => 'AwsSecurityFindingFilters'], 'GroupByAttribute' => ['shape' => 'NonEmptyString']]], 'UpdateInsightResponse' => ['type' => 'structure', 'members' => []], 'VerificationState' => ['type' => 'string', 'enum' => ['UNKNOWN', 'TRUE_POSITIVE', 'FALSE_POSITIVE', 'BENIGN_POSITIVE']], 'WorkflowState' => ['type' => 'string', 'enum' => ['NEW', 'ASSIGNED', 'IN_PROGRESS', 'DEFERRED', 'RESOLVED']]]];
